(defun mosaic-plot (&optional (data nil data?) &rest args)
  (let* ((numargs (length args)))
    (cond
      ((not data)                               ; 0 args: new style
       (mosaic-plot-new))
      ((and data (not args))                    ; 1 arg:  new style
       (mosaic-plot-new data))
      ((and (listp data)           
            (first args)
            (listp (first args)))               ; 2 args, both lists: old style
       (apply #'mosaic-plot-classic data args))
      ((> (length args) 1)                      ; 3 or more args: new style 
       (apply #'mosaic-plot-new data args))
      (t ;error
         (fatal-message " Mosaic-Plot: Bad Argument Structure"))
      )))


(defun bar-graph (&optional (data nil data?) &rest args)
  (let* ((numargs (length args)))
    (cond
      ((not data)                               ; 0 args: new style
       (bar-graph-new))
      ((and data (not args))                    ; 1 arg:  new style
       (bar-graph-new data))
      ((and (listp data)
            (first args)
            (listp (first args)))               ; 2 args, both lists: old style
       (apply #'bar-graph-classic data args))
      ((> (length args) 1)                      ; 3 or more args: new style
       (apply #'bar-graph-new data args))
      (t ;error
         (fatal-message " Bar-Graph: Bad Argument Structure"))
      )))


(defun bar-graph-new
  (&optional data 
       &rest args 
       &key  (ok-var-types '(category))
             way-labels level-labels 
             variable-labels ;alias of way-labels 
             point-labels    ;irrelevant
             (show t) (top-most t) 
             (location '(50 50)) (size '(320 320))
             (title "Bar Graph") 
             (legend1) ;(legend1 (send $ :name))
             (legend2 "Bar Graph") (legend (send $ :name))
             (content-only nil) (go-away t)
;do not use :menu :in?, :in??, or :in??? - reserved for system use
             (in nil in??) (in? nil in???) (menu t)
;unique keywords follow - plot-values doesn't work correctly
             (freq nil) (freqs nil) (connect t) (stacked nil)
             plot-values color-values (standardize t) (connect-button t)
             (plot-button nil) ; leave nil until plot-values is fixed
             )
  (let* ((actcon *active-container*)
         (in? (if in??? in? in??))
         (graph-frame (graph-frame :show nil))
         (pop-out (send graph-frame :seen-in in in?))
         (container (if (equal pop-out t) graph-frame pop-out))
         (graph-data (before-new-cells-graph data));(before-new-bargraph data)
         (data-object (fourth graph-data))
         (linkable nil)
         (linked nil)
         (graph) (cells) (levels))
    (unless way-labels    (setf way-labels (second graph-data)))
    (unless level-labels  (setf level-labels (third graph-data)))
                          (setf cells  (first  (first graph-data)))
                          (setf levels (second (first graph-data)))
    (when (or (= 1 (length way-labels)) 
              (= 4 (length way-labels)))
          (setf stacked nil))
    (unless legend1       (setf legend1 (if data-object 
                                            (send data-object :name)
                                            "Unnamed Data")))
    (unless title         (setf title legend2))
    (if (or freq freqs)   (setf freq t))
    (setf graph
          (send stacked-bar-graph-proto 
                :new cells levels 
                :freq freq 
                :connect connect
                :way-labels way-labels 
                :level-labels level-labels
                :color-values color-values 
                :standardize standardize 
                :stacked stacked 
                :legend1 legend1 
                :legend2 legend2
                :title title 
                :show nil
                :size size 
                :location location))
    (send graph :plot-buttons :new-x nil :new-y t :free nil :mouse-mode nil) 
    (send graph :title title)
    (send graph :legend1 legend1)
    (send graph :title (strcat title " [" (send graph :legend1) "]"))
    (send graph :make-two-plot-menus
                "BarGraph"
                :hotspot-items '(help dash new-y dash
                                 show-plots hide-plots close-plots dash 
                                 print save copy dash on-top maximize)
                :popup-items   '(no-items))
    (when graph 
          (send graph :after-new-plot pop-out top-most show size container 
                linkable linked data-object content-only))
    graph))
